﻿'''
 Demonstrates loading .ui files with PySide2
 Note: run this sample using the Scripting > Run Script menu item 
'''
import os
from PySide2.QtWidgets import QWidget, QMainWindow
from PySide2.QtCore import QFile
from PySide2.QtUiTools import QUiLoader
from pymxs import runtime as rt

class MyWindow(QMainWindow):
    """
    Main window class object loading a .ui file
    """
    def __init__(self, parent=None):
        super(MyWindow, self).__init__(parent)
        self.setWindowTitle('Pyside2 Qt Window')
        self.init_ui()

    def init_ui(self):
        """ Prepare Qt UI layout for main window content """
        ui_file = QFile(os.path.dirname(os.path.realpath(__file__)) + "\\test_ui.ui")
        ui_file.open(QFile.ReadOnly)
        self.loaded_ui = QUiLoader().load(ui_file, self)
        ui_file.close()

def demo_ui_loader():
    """
    Entry point to demonstrate how to load a .ui file
    """
    # reset 3ds Max
    rt.resetMaxFile(rt.Name('noPrompt'))

    win = MyWindow(QWidget.find(rt.windows.getMAXHWND()))
    win.show()

demo_ui_loader()
